//=============================================================================
//
// ͏ [input.h]
// Author : KENSUKE WATANABE
//
//=============================================================================
#pragma once
#ifndef _INPUTJOYSTICK_H_
#define _INPUTJOYSTICK_H_

#include "input.h"

//-----------------------------------------------------------------------------
// WCXeBbN
//-----------------------------------------------------------------------------
class CInputJoyStick : public CInput
{
public:
	typedef enum	// {^zu
	{
		BUT_1 = 0,	// 1
		BUT_2,		// 2
		BUT_3,		// 3
		BUT_4,		// 4
		BUT_L1,		// L1
		BUT_R1,		// R1
		BUT_L2,		// L2
		BUT_R2,		// R2
		BUT_9,		// 9
		BUT_10,		// 10 SELECT
		BUT_L3,		// L3 START
		BUT_R3,		// R3
		NUM_BUT_MAX = 32
	}ELECOM_BUTTON;

	CInputJoyStick() { m_nCntUseJoy++; }
	~CInputJoyStick() { m_nCntUseJoy--; }

	HRESULT Init(HINSTANCE hInst, HWND hWnd);
	void Uninit(void);
	void Update(void)override;

	static BOOL CALLBACK EnumJoysticksCallback(const DIDEVICEINSTANCE *pdidInstance, void* pContext);
	static BOOL CALLBACK EnumAxisCallback(const DIDEVICEOBJECTINSTANCE *pdidoi, void* pCintext);

	bool GetPress(int nKey) { return (m_aState[nKey] & 0x80) ? true : false; }
	bool GetTrigger(int nKey) { return (m_aStateTrigger[nKey] & 0x80) ? true : false; }
	bool GetRelease(int nKey) { return (m_aStateRelease[nKey] & 0x80) ? true : false; }
	bool GetRepeat(int nKey) { return (m_aStateRepeat[nKey] & 0x80) ? true : false; }
	void FlushTrigger(int nKey) { m_aStateTrigger[nKey] = 0; }
	D3DXVECTOR2 GetLeftAxis() { return D3DXVECTOR2((float)m_nLx, (float)m_nLy); }
	D3DXVECTOR2 GetRightAxis() { return D3DXVECTOR2((float)m_nLz, (float)m_nLRz); }
	int GetCntUse(void) { return m_nCntUseJoy; }

private:
	DIDEVCAPS	m_diDevCaps;					// 
	BYTE		m_aState[NUM_BUT_MAX];			// WCXeBbN̓͏񃏁[N LĂ邩
	BYTE		m_aStateTrigger[NUM_BUT_MAX];	// WCXeBbÑgK[񃏁[Nu
	BYTE		m_aStateRelease[NUM_BUT_MAX];	// WCXeBbÑ[X񃏁[Nu
	BYTE		m_aStateRepeat[NUM_BUT_MAX];	// WCXeBbÑs[g񃏁[N
	int			m_aStateRepeatCnt[NUM_BUT_MAX];	// WCXeBbÑs[gJE^
	int			m_nLx;							// XeBbN̎E
	int			m_nLy;							// XeBbN̎㉺
	int			m_nLz;							// EXeBbN̏㉺
	int			m_nLRz;							// EXeBbN̍E
	bool		m_bstick;						// WCXeBbN邩
	bool		m_bJoystick;					// WCXeBbNgp邩ǂ
	int			m_nCntUseJoy;					// gpWCXeBbN̐

	static LPDIRECTINPUTDEVICE8 m_pDIDevice;	// DeviceIuWFNg(͂ɕKv)
};

#endif